package cn.com.duiba.kjy.api.params.corp;

import cn.com.duiba.kjy.api.enums.corp.CorpCompanyEnableEnum;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: HanYaLun
 * @description: 更改企业状态
 * @create: 2021-08-25 10:55 上午
 */
@Data
public class ChangeCompanyStateParam implements Serializable {
    private static final long serialVersionUID = -2443365123275771993L;

    /**
     * 企业主键
     */
    @NotNull(message = "公司标识不能为空")
    private Long id;

    /**
     * 企业是否可用，上线：1，下线：0
     *
     * @see CorpCompanyEnableEnum
     */
    @NotNull(message = "公司状态不能为空")
    private Integer companyEnable;
}
