package cn.com.duiba.kjy.api.params.user;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 用户与公众号交互信息-查询条件
 * @author lizhi
 * @date 2019/12/3 5:22 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UsersWxInteractionSearchParams extends PageQuery {

    private static final long serialVersionUID = -1016437328495693121L;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 公众号ID，对应tb_official_accounts.id
     */
    private Long oaId;

    /**
     * 用户的标识，对当前公众号唯一
     */
    private String openId;

    /**
     * 最后一次跟公众号交互的时间（开始时间-包含）
     */
    private Date startLastInteractionTime;

    /**
     * 最后一次跟公众号交互的时间（结束时间-不包含）
     */
    private Date endLastInteractionTime;
}
