package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.PayResultDto;
import cn.com.duiba.kjy.api.dto.SellerPayRecordDto;
import cn.com.duiba.kjy.api.dto.order.PayRecordAndDistributionInfoDto;
import cn.com.duiba.kjy.api.dto.seller.SellerPayMoneyTotalDto;
import cn.com.duiba.kjy.api.params.PayOrderManageParam;
import cn.com.duiba.kjy.api.params.seller.SellerPayRecordParams;
import cn.com.duiba.user.service.api.dto.user.UserDto;

import java.util.List;

/**
 * Created by zhangshun on 2019/2/20.
 */
@AdvancedFeignClient
public interface RemoteSellerPayRecordService {

    /**
     * 根据销售员ID和支付状态查询
     * @param sellerId
     * @return
     */
    SellerPayRecordDto findBySellerWaitInPay(Long sellerId);

    /**
     * 根据销售员ID查询最新的一笔支付记录
     * @param sellerId
     * @return
     */
    SellerPayRecordDto findRecentlyPayRecord(Long sellerId);

    /**
     * 获取交易号
     * @return
     */
    @Deprecated
    SellerPayRecordDto addPayRecord(SellerPayRecordDto dto);

    /**
     * 新增订单信息
     * @param dto 支付订单和分销关系快照信息
     * @return
     */
    SellerPayRecordDto addSellerPayRecord(PayRecordAndDistributionInfoDto dto);

    /**
     * 更新状态
     * 当数据库中订单状态已经是最终状态@see SellerPayStatusEnum.immutableStatusList 时
     * 不能修改
     * @param id ID
     * @param status 状态值
     * @return
     */
    Boolean updateStatus(Long id, Integer status);

    Boolean error(String tradeNum, String errorMessage);

    /**
     * 根据交易号查询
     * @param tradeNo 交易流水号
     * @return
     */
    SellerPayRecordDto findByTradeNo(String tradeNo);


    /**
     * 根据交易号查询(微信订单流水号)
     * @param payTradeNo 微信订单流水号
     * @return
     */
    SellerPayRecordDto findByPayTradeNo(String payTradeNo);

    /**
     * 支付结果处理
     * @param payResultDto
     * @return
     */
    Boolean handlePayResult(PayResultDto payResultDto);

    /**
     * 创建兑吧订单成功后，将兑吧订单号回填到客集集购买记录里
     * @param
     * @param duibaTradeNo
     * @return
     */
    int updateDuibaTradeNo(String tradeNo,String duibaTradeNo);

    Boolean updatePresentUserId(Long id, Long presentUserId);

    List<SellerPayRecordDto> selectList(SellerPayRecordDto pojo);

    /**
     * 根据销售员ID和支付状态查询条数
     * @param sellerId
     * @param payStatus
     * @return
     */
    int findCountBySellerAndStatus(Long sellerId, Integer payStatus);

    /**
     * 批量获取销售员付费金额总数
     * @param sellerIds
     * @return
     */
    List<SellerPayMoneyTotalDto> findSellerPayMoneyTotal(List<Long> sellerIds);

    /**
     * 列表查询
     * @param payRecordParams
     * @return
     */
    List<SellerPayRecordDto> findByParam(SellerPayRecordParams payRecordParams);

    /**
     * 根据 支付订单管理查询页面查询条件筛选支付订单
     */
    List<SellerPayRecordDto> findSellerPayRecordByCondition(PayOrderManageParam condition);

    /**
     * 计数
     */
    Long  countSellerPayRecordByCondition(PayOrderManageParam condition);

    /**
     * 查询最近支付成功的用户信息
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<UserDto> selectRecentlyPaySuccessUserList(Integer pageIndex, Integer pageSize);

    /**
     * 查询销售员id集合付款成功的最新的记录
     * @param sellerIds
     * @return
     */
    List<SellerPayRecordDto> selectRecentlyPaySuccessRecordBySellerIds(List<Long> sellerIds);


    /**
     * 通过主键ID，获取详情
     * @param id
     * @return
     */
    SellerPayRecordDto findById(Long id);


    /**
     * 通过主键ID列表，获取详情列表
     * @param ids
     * @return
     */
    List<SellerPayRecordDto> findByIdList(List<Long> ids);

    /**
     * 根据销售ID查询最新的两笔订单信息
     * @param sellerId 销售id
     * @return 查询结果
     */
    List<SellerPayRecordDto> findBySellerIdTwoRow(Long sellerId);
}
