package cn.com.duiba.kjy.api.remoteservice.sellercustomerintention;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellercustomerintention.SellerCustomerIntentionDto;
import cn.com.duiba.kjy.api.dto.sellercustomerintention.SellerCustomerScoreDto;
import cn.com.duiba.kjy.api.params.sellercustomerintention.SellerCustomerIntentionUpdateParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-09-21 18:35
 * @descript 客户意向度remoteService
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerIntentionService {

    /**
     * 新增或更新意向度
     * @param param
     * @return
     */
    int saveOrUpdate(SellerCustomerIntentionUpdateParam param);

    /**
     * 批量计算更新
     * @param dtos
     */
    void calculateAndPaddingCustomerIntention(List<SellerCustomerIntentionDto> dtos);

    /**
     * 根据客户id查询
     * @param sellerCustomerId
     * @return
     */
    SellerCustomerIntentionDto findByCustomerId(Long sellerCustomerId);

    /**
     * 获取意向度最高的size个
     * @param sellerId
     * @return
     */
    List<SellerCustomerIntentionDto> listByIntention(Long sellerId, Integer size);

    /**
     * 获取客户得分
     * @param sellerCustomerId
     * @return
     */
    SellerCustomerScoreDto findScoreByCustomerId(Long sellerCustomerId);

}
