package cn.com.duiba.kjy.api.dto;

import cn.com.duiba.kjy.api.enums.BatchCodeRuleEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhanghuifeng
 * date 2019-04-18-16:03
 */
@Data
public class ActivationCodeBatchDto implements Serializable {
    private static final long serialVersionUID = 6568990186975940861L;

    /**
     * 批次
     */
    private String batch;

    /**
     * 有效期
     */
    private Integer vipValidity;

    /**
     * 类型
     */
    private Integer codeType;

    /**
     * 数量
     */
    private Integer codeTotal;

    /**
     * 位数
     */
    private Integer digitTotal;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 批次激活码组成规则
     * @see BatchCodeRuleEnum
     */
    private String batchCodeRule;

    private String activationCode;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 用户版本信息
     * @see cn.com.duiba.kjy.api.enums.version.UserVersionEnum
     */
    private Integer userVersion;

    /**
     * 销售id
     */
    private Long agentSellerId;

    /**
     * 所在省份
     */
    private String province;

    /**
     * 所在城市
     */
    private String city;

}
