package cn.com.duiba.kjy.api.dto.advice;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 成功案例配置表
 * @author kjj mybatis generator 
 * 2020-08-17
 */
@Data
public class SuccessCaseDto implements Serializable {
    private static final long serialVersionUID = 15976516645961371L;

    /**
     *
     *主键ID
     * not null default = null
     */
    private Long id;

    /**
     *
     *话术类型：1:faq关联问答 2:咨询问题 3:领取资料 4:领取赠险
     * not null default = null
     */
    private Integer caseType;

    /**
     *
     *关联外建ID
     * not null default = null
     */
    private String bizId;

    /**
     *
     *案例描述
     * max length = 100
     * not null default = 
     */
    private String describeTitle;

    /**
     *
     *案例详情
     * max length = 200
     * not null default = 
     */
    private String caseDetail;

    /**
     *
     *案例文章Id
     * not null default = 0
     */
    private Long contentId;

    /**
     *
     *案例状态 0:删除 1:可用
     * not null default = 1
     */
    private Integer caseStatus;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    @Data
    public static class CaseDetail{
        private String name;
        private String headUrl;
    }
}