package cn.com.duiba.kjy.api.dto.appvideo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-08-16 14:17
 * 跟拍助手-视频模板迁移数据格式
 */
@Data
public class AppVideoTemplateMigrateDto implements Serializable {

    private static final long serialVersionUID = 6953798138298059291L;

    /**
     *
     * 栏目ID
     */
    private Long classificationId;

    /**
     * 视频类型：1:普通视频 2:动画合成视频
     * @see cn.com.duiba.kjy.api.enums.appvideo.AppVideoTemplateTypeEnum
     */
    private Integer videoType;

    /**
     * 视频标题
     */
    private String videoTitle;

    /**
     * 视频封面地址
     */
    private String videoCoverUrl;

    /**
     * 视频标签
     */
    private String videoTag;

    /**
     * 视频脚本简短描述
     */
    private String shortScript;

    /**
     * 视频时长
     */
    private Integer videoDuration;

    /**
     * 视频权重，越大越靠前
     */
    private Long sortIndex;

    /**
     * 模版视频地址
     */
    private String videoUrl;

    /**
     * 模版视频脚本地址
     */
    private String videoScriptUrl;

    /**
     * 相框地址
     */
    private List<String> frameList;
}
