package cn.com.duiba.kjy.api.dto.clockin;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 打卡任务进度表
 *
 * @author xuzhigang
 */
@Data
public class SellerClockInTaskProgressDto implements Serializable {
    private static final long serialVersionUID = 6309782646275620752L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 任务id tb_clock_in_task_config.id
     */
    private Long taskId;

    /**
     * 打卡id id tb_seller_clock_in_progress.id
     */
    private Long clockInProgressId;

    /**
     * 任务状态 1-初始化 2-完成 3-失败
     * @see cn.com.duiba.kjy.api.enums.clockin.ClockInTaskStatusEnum
     */
    private Integer taskStatus;

    /**
     * 完成日期
     */
    private Date doneTime;

    /**
     * 完成任务次数
     */
    private Integer doneTimes;

    /**
     * 1-正常完成 2-补卡完成
     * @see cn.com.duiba.kjy.api.enums.clockin.ClockInDoneTypeEnum
     */
    private Integer doneType;
}

