package cn.com.duiba.kjy.api.dto.corp;

import lombok.Data;

import java.io.Serializable;

/**
 * @author: HanYaLun
 * @description: 页面信息
 * @create: 2021-08-24 8:18 下午
 */
@Data
public class PageInfoDto implements Serializable {
    private static final long serialVersionUID = 6405005853665899682L;

    /**
     * 主键Id
     */
    private Long id;

    /**
     * 权限id
     */
    private Long authId;

    /**
     * 页面名称
     */
    private String pageName;

    /**
     * 页面url
     */
    private String pageUrl;

    /**
     * 页面状态
     * 是否被隐藏,未隐藏：0，已隐藏：1
     * @see cn.com.duiba.kjy.api.enums.corp.PageVisibleEnum
     */
    private Integer hideState;
}
