package cn.com.duiba.kjy.api.dto.lottery;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2019/10/23 2:55 PM
 */
@Data
public class LotteryPrizeDto implements Serializable {

    private static final long serialVersionUID = -7855698732206819191L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 抽奖ID
     */
    private Long lotteryId;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 中奖概率
     */
    private Integer prizeRate;

    /**
     * 中奖优先级
     */
    private Integer prizePriority;

    /**
     * 可中次数
     */
    private Integer prizeTimes;

    /**
     * 可中次数类型：0-永久，1-每日
     * @see cn.com.duiba.kjy.api.enums.lottery.LotteryTimesTypeEnum
     */
    private Integer prizeTimesType;

    /**
     * 总库存，-1表示不限制库存
     */
    private Integer totalStock;

    /**
     * 剩余库存
     */
    private Integer remainingStock;

    /**
     * 第三方剩余库存
     */
    private Integer thirdRemainingStock;

    /**
     * 在抽奖游戏中的顺序
     */
    private Integer lotteryOrder;
}

