package cn.com.duiba.kjy.api.dto.marketing;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 营销礼物库
 * @author liuchao
 * @date 2020-02-22
 */
@Data
public class MarketingGiftDto implements Serializable {
    private static final long serialVersionUID = 15823569124442798L;

    /**
     *主键id
     */
    private Long id;

    /**
     *礼物名称
     */
    private String giftName;

    /**
     *礼物图片地址
     */
    private String giftPicUrl;

    /**
     *礼物状态，1=已上架，2=未上架
     * @see cn.com.duiba.kjy.api.enums.marketing.MarketingGiftStateEnum
     */
    private Integer giftState;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}
