package cn.com.duiba.kjy.api.dto.reward;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 点对点中奖活动
 * @author kjj mybatis generator 
 * @date 2021-03-08
 */
@Data
public class RewardActivityDto implements Serializable {
     
    private static final long serialVersionUID = 16151828357621581L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售人员id
     */
    private Long sellerId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 活动类型 1=点对点 2=社群
     * @see cn.com.duiba.kjy.api.enums.reward.RewardActivityTypeEnum
     */
    private Integer activityType;

    /**
     * 活动关联的资源类型 1=视频
     * @see cn.com.duiba.kjy.api.enums.reward.RewardResourceTypeEnum
     */
    private Integer resourceType;

    /**
     * 活动关联的id
     */
    private Long resourceId;

    /**
     * 开奖时间
     */
    private Date awardTime;

    /**
     * 奖品名称
     */
    private String awardName;

    /**
     * 奖品图片
     */
    private String awardImage;

    /**
     * 奖品总库存
     */
    private Integer awardStock;

    /**
     * 奖品剩余数量
     */
    private Integer awardLeft;

    /**
     * 活动状态
     * @see cn.com.duiba.kjy.api.enums.reward.RewardActivityStatusEnum
     */
    private Integer activityStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}