package cn.com.duiba.kjy.api.dto.seller;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: linjianhui
 * @date: 2020/10/26 13:38
 * @description: 代理人客集集使用数据统计
 */
@Data
public class SellerUseStatisticsDto implements Serializable {

    private static final long serialVersionUID = 4293113288727910206L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 客集集使用天数
     */
    private Long useDayNum;

    /**
     * 累计转发素材
     */
    private Long forwardMaterialNum;

    /**
     * 有效客户线索
     */
    private Long accurateMaterialNum;

    /**
     * 获客人数
     */
    private Long customerNum;

    /**
     * 二度人脉数
     */
    private Long customerOriginNum;

    /**
     *
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

}
