package cn.com.duiba.kjy.api.enums.anxietyRisk;

import java.util.HashMap;
import java.util.Map;

/**
 * @auther: xiaotian
 * @date: 2019-12-03 17:00
 * @description: 焦虑类型评测状态枚举
 */
public enum AnxietyRiskStateEnum {

    DELETE(-1, "删除"),
    NOT_ENABLE(0, "未启用"),
    ENABLE(1, "启用"),
    ;

    private Integer code;
    private String desc;

    AnxietyRiskStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, AnxietyRiskStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(AnxietyRiskStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static AnxietyRiskStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }}
