package cn.com.duiba.kjy.api.enums.clockin;


import java.util.HashMap;
import java.util.Map;

/**
 * @auther: linjianhui
 * @date: 2020-06-30 13:32
 * @description: 60 天打卡任务状态
 */
public enum ClockInTaskStatusEnum {

    /**
     * 任务状态
     */
    INIT(1, "进行中"),
    COMPLETE(2, "完成"),
    FAIL(3, "失败"),
    REFUND(4, "发起退款"),

    ;

    private Integer code;
    private String desc;

    ClockInTaskStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, ClockInTaskStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ClockInTaskStatusEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static ClockInTaskStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
