package cn.com.duiba.kjy.api.enums.sellerImport;

/**
 * 视频上传类型筛选枚举
 * @author 小天
 * @date 2020-06-26 19:47
 **/
public enum VideoUploadTypeEnum {

    /**
     * 内部上传
     */
    INNER(1,"内部上传"),
    /**
     * 用户上传
     */
    SELLER(2,"用户上传");

    VideoUploadTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    };

    private Integer type;
    private String desc;

    public static VideoUploadTypeEnum getByType(Integer areaType) {
        for (VideoUploadTypeEnum enumVal : VideoUploadTypeEnum.values()) {
            if (enumVal.getType().equals(areaType)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
