package cn.com.duiba.kjy.api.params.seller;

import lombok.Data;

import java.io.Serializable;

/**
 * 代理人访问链路反馈查询参数
 * @author 吴文哲
 * @date 2020-02-26 10:25
 **/
@Data
public class SellerVisitPathParam implements Serializable {
    private static final long serialVersionUID = 2902250821714214846L;

    /**
     * 访客id
     */
    private Long visitorId;

    /**
     * 反馈类型
     * @see cn.com.duiba.kjy.api.enums.seller.SellerFeedbackEnum
     *
     */
    private Integer feedbackType;

    /**
     * 刷新状态
     * @see cn.com.duiba.kjy.api.enums.seller.SellerVisitPathRefreshTypeEnum
     */
    private Integer refreshType;



}
