package cn.com.duiba.kjy.api.remoteservice.anxietyRisk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.anxietyRisk.AnxietyRiskDto;

import java.util.List;

/**
 * Service
 *
 * @author chentiecheng
 * 2020-11-20 14:58:18
 */
@AdvancedFeignClient
public interface RemoteAnxietyRiskService {
    /**
     * 新增记录
     */
    Boolean save(AnxietyRiskDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(AnxietyRiskDto dto);

    /**
     * 根据id获取
     */
    AnxietyRiskDto getById(Long id);

    /**
     * 根据焦虑类型获取
     *
     * @param anxiety
     * @return
     */
    AnxietyRiskDto getInUseByAnxietyType(Integer anxiety);

    /**
     * 管理后端查询
     *
     * @return
     */
    List<AnxietyRiskDto> selectPage(Integer anxiety);


    /**
     * 根据评测Id获取
     *
     * @param activityId
     * @return
     */
    AnxietyRiskDto getByActivityId(Long activityId);


    /**
     * 查询全部可用的
     *
     * @return
     */
    List<AnxietyRiskDto> selectAllCanUsed();

}
