package cn.com.duiba.kjy.api.remoteservice.interact;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.interact.ArticleInteractRefDto;
import cn.com.duiba.kjy.api.params.PageQuery;
import cn.com.duiba.kjy.api.params.interact.InteractArticleCountParam;
import cn.com.duiba.kjy.api.params.interact.InteractArticleSearchParam;

import java.util.List;
import java.util.Map;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-07-26 09:53
 * 关联了互动方案的文章 rpc service
 */
@AdvancedFeignClient
public interface RemoteInteractArticleApiService {

    /**
     * 批量统计关联了此互动方案的文章数量（仅管理后台可用！！）
     * @param interactIds 互动方案id
     * @return key：互动方案id value：文章数量
     */
    Map<Long, Integer> countByInteractIds(List<Long> interactIds);

    /**
     * 统计关联了互动方案的文章
     * @param param 文章id + 互动方案id数组
     * @return 文章数量
     */
    int countInteractArticle(InteractArticleCountParam param);

    /**
     * 查询关联表中的文章id
     * @param pageQuery 查询参数
     * @return 文章id
     */
    List<Long> searchArticleIds(PageQuery pageQuery);

    /**
     * 查询关联了互动方案的文章
     * @param param 文章id + 互动方案id数组
     * @return 文章列表
     */
    List<ArticleInteractRefDto> searchList(InteractArticleSearchParam param);

    /**
     * 通过文章id获取关联数据
     * @param articleId 文章id
     * @return 关联数据
     */
    List<ArticleInteractRefDto> searchByArticleId(Long articleId);

    /**
     * 批量新增
     * @param dtoList 关联数据
     * @return 新增结果
     */
    int batchInsert(List<ArticleInteractRefDto> dtoList);

    /**
     * 删除文章-互动方案关联关系
     * @param articleId 文章id
     * @return 删除结果
     */
    boolean deleteByArticleId(Long articleId);
}
