package cn.com.duiba.kjy.api.remoteservice.kouyi;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.kouyi.KouyiCourseDto;

import java.util.Date;
import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-09-09 11:47
 * @descript 口以课程remoteService
 */
@AdvancedFeignClient
public interface RemoteKouyiCourseService {

    /**
     * 根据主键查询课程
     * @param id
     * @return
     */
    KouyiCourseDto findById(Long id);

    /**
     * 根据日期除余返回
     * @param day
     * @return
     */
    List<KouyiCourseDto> getByDay(Date day);

    /**
     * 根据日期除余查询总数
     * @param day
     * @return
     */
    int countByDay(Date day);

    /**
     * 根据ids查询列表
     * @param ids
     * @return
     */
    List<KouyiCourseDto> listByIds(List<Long> ids);
}
