package cn.com.duiba.kjy.api.remoteservice.layer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.layer.LayerConfigDto;
import cn.com.duiba.kjy.api.params.layer.LayerConfigParam;
import cn.com.duiba.kjy.api.params.layer.LayerConfigQueryParam;

import java.util.List;

/**
 * 弹层rpc服务类
 * @author 吴文哲
 * @date 2020-03-25 18:43
 **/
@AdvancedFeignClient
public interface RemoteLayerConfigService {

    /**
     * 根据条件查询列表
     * @param param
     * @return
     */
    List<LayerConfigDto> listByCondition(LayerConfigQueryParam param);

    /**
     * 根据条件统计
     * @param param
     * @return
     */
    Integer countByCondition(LayerConfigQueryParam param);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    LayerConfigDto findById(Long id);

    /**
     * 根据主键逻辑删除
     * @param id
     * @return
     */
    Integer delById(Long id) throws KjyCenterException;

    /**
     * 保存弹层配置信息
     * @param param
     * @return
     */
    Boolean saveLayerConfig(LayerConfigParam param) throws KjyCenterException;

    /**
     * 保存弹层配置信息 返回id
     * @param param
     * @return
     */
    Long saveOrUpdateLayerConfig(LayerConfigParam param) throws KjyCenterException;

}
