package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerDistributionStatisticsDto;
import cn.com.duiba.kjy.api.params.SellerLowerQryParam;

import java.util.List;

/**
 * @author wangjianwei
 * @date 2021/6/2 7:51 下午
 */
@AdvancedFeignClient
public interface RemoteSellerDistributionStatisticsService {
    /**
     * 批量查询seller统计信息
     * @param sellerIds  sellerId集合
     * @return
     */
    List<SellerDistributionStatisticsDto> statisticsList(List<Long> sellerIds);

    /**
     * 当前seller存在即更新，不存在新增
     *
     * @param statisticsDto
     * @return
     */
    Boolean insertExistUpdate(SellerDistributionStatisticsDto statisticsDto);

    /**
     * 分页查询统计信息
     *
     * @param sellerLowerQryParam
     * @return
     */
    int count4DistributionSta(SellerLowerQryParam sellerLowerQryParam);

}
