package cn.com.duiba.kjy.api.remoteservice.sms.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sms.SmsPushDto;
import cn.com.duiba.kjy.api.dto.sms.SmsTemplateDto;
import cn.com.duiba.kjy.api.params.sms.PushParam;

import java.util.List;

/**
 * @author gxy
 * @date 2021/5/27 2:33 下午
 */
@AdvancedFeignClient
public interface RemoteSmsPushService {

    /**
     * 分页查询
     * @param param 条件
     * @return 查询结果
     */
    List<SmsPushDto>  selectSmsPushTaskPage(PushParam param);

    /**
     * 根据条件查询总记录数
     * @param param 条件
     * @return 总数
     */
    Long  selectCount(PushParam param);

    /**
     * 根据主键删除推送
     * @param id 主键
     * @return 删除结果
     */
    Integer delById(Long id);

    /**
     * 根据id查询详情
     * @param id 主键
     * @return 查询结果
     */
    SmsPushDto selectById(Long id);

    /**
     * 新增
     * @param dto 新增数据
     * @return id
     */
    Long save(SmsPushDto dto);

    /**
     * 修改
     * @param dto 修改参数
     * @return 修改结果
     */
    Integer update(SmsPushDto dto);

    /**
     * 根据模版Id查询
     * @param smsTemplateId 模版id
     * @return 查询结果
     */
    List<SmsPushDto> selectByTemplateId(Long smsTemplateId);

    /**
     * 根据模版Ids批量查询
     * @param list 模版id
     * @return 查询结果
     */
    List<SmsPushDto> selectByTemplateIds(List<Long> list);

    /**
     * 批量修改
     * @param list 修改数据
     * @return 修改结果
     */
    Integer updateList(List<SmsPushDto> list);

    /**
     * 模版审核回执后修改状态
     * @param smsTemplateDto 模版对象
     * @param pushDtoList 推送集合
     */
    void updateReviewStatus(SmsTemplateDto smsTemplateDto, List<SmsPushDto> pushDtoList);

}
