package cn.com.duiba.kjy.api.remoteservice.survey;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.survey.SurveyDetailDto;
import cn.com.duiba.kjy.api.dto.survey.SurveyDto;
import cn.com.duiba.kjy.api.dto.survey.SurveyExportResultDto;
import cn.com.duiba.kjy.api.dto.survey.SurveyListDto;
import cn.com.duiba.kjy.api.params.survey.SurveyExportParam;
import cn.com.duiba.kjy.api.params.survey.SurveyQueryParam;

import java.util.List;

/**
 * 管理后台-问卷服务
 * @author liuchao1
 * @version 1.0
 * @date 2020-11-24 19:00
 */
@AdvancedFeignClient
public interface RemoteSurveyManagerService {

    /**
     * 分页查询接口
     * @param param
     * @return
     */
    List<SurveyListDto> findPageList(SurveyQueryParam param);

    /**
     * 统计总数
     * @param param 条件
     * @return 总数
     */
    Integer count(SurveyQueryParam param);

    /**
     * 根据问卷id获取问卷信息
     * @param surveyId 问卷id
     * @return 问卷信息，不含问题、选项等相关信息
     */
    SurveyDto findById(Long surveyId);

    /**
     * 根据问卷id获取问卷详情信息
     * @param surveyId 问卷id
     * @return 问卷详情信息
     */
    SurveyDetailDto detail(Long surveyId);

    /**
     * 保存问券
     * @param dto 问卷详情信息
     * @return 问卷id
     */
    Long saveOrUpdate(SurveyDetailDto dto) throws KjyCenterException;

    /**
     * 更新问券状态
     * @param id 问卷id
     * @param surveyStatusEnum 问卷新状态
     * @return 更新结果
     */
    boolean updateStatus(Long id, Integer surveyStatusEnum);

    /**
     * 删除问券
     * @param surveyId 问卷id
     * @return 删除结果
     */
    boolean delete(Long surveyId);

    /**
     * 导出问券，header与content分开
     * @param surveyExportParam 导出参数
     * @return 导出结果
     * @throws KjyCenterException 导出异常
     */
    SurveyExportResultDto export(SurveyExportParam surveyExportParam);

}
