package cn.com.duiba.kjy.api.remoteservice.clockin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.clockin.SellerClockInProgressDto;
import cn.com.duiba.kjy.api.enums.clockin.ClockInTypeEnum;

import java.util.Date;

/**
 * 打卡进度
 *
 * @author xuzhigang
 * @date 2021/4/14 9:45 上午
 **/
@AdvancedFeignClient
public interface RemoteSellerClockInProgressService {

    /**
     * 根据sellerId和打卡类型查询未结束的打卡进度
     *
     * @param sellerId 销售id
     * @param clockInType 打卡类型 {@link cn.com.duiba.kjy.api.enums.clockin.ClockInTypeEnum}
     * @return 打卡进度
     */
    SellerClockInProgressDto selectNotEndBySellerIdAndClockType(Long sellerId, Integer clockInType);

    /**
     * 根据代理人ID和打卡类型查询条数（未删除）
     * @param sellerId     代理人ID
     * @param clockInType 打卡类型 {@link ClockInTypeEnum}
     * @return 条数
     */
    int countBySellerIdAndClockType(Long sellerId, Integer clockInType);

    /**
     * 初始化打卡进度
     *
     * @param sellerId 销售id
     * @param bizId 业务id
     * @param bizType 业务类型
     * @param beginDate 任务开始时间
     * @param clockInConfId 打卡规则id
     * @return 执行结果
     */
    int init(Long sellerId, Long bizId, Integer bizType, Date beginDate, Long clockInConfId);

    /**
     * 根据销售id和状态查询180天打卡的数据
     * 状态为空时,查询全状态
     *
     * @param sellerId 销售id
     * @param status   状态 {@link cn.com.duiba.kjy.api.enums.clockin.ClockInStatusEnum}
     * @return 查询到的数据
     */
    SellerClockInProgressDto selectNewestBySellerIdAndStatus(Long sellerId, Integer status);
}
