/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.constant;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum ContentTypeEnum {
    ARTICLE("article", "\u93c2\u56e9\u73f7"),
    ACTIVITY("activity", "\u5a32\u8bf2\u59e9"),
    DAILY("daily", "\u93c3\u2542\u59e4"),
    POSTER("poster", "\u5a34\u950b\u59e4"),
    AFTERNOON("afternoon", "\u9357\u581d\u6097\u7487\u6fcb\ue57d"),
    EVENING("evening", "\u93c5\u6c2c\u7568\u8e47\u51ad\ue1e2"),
    SELLER("seller", "\u95bf\ufffd\u935e\ue1bc\u61b3\u935a\u5d87\u5896"),
    OUTER_MARKET("outer_market", "\u9475\u677f\u769d\u9477\ue044\u757e\u6d94\u5910\u647c\u93ba\ufffd"),
    OUTER_EXCLUSIVE("outer_exclusive", "\u6d93\u64b3\u5c2f\u9477\ue044\u757e\u6d94\u5910\u647c\u93ba\ufffd");

    private String code;
    private String desc;
    private static final Map<String, ContentTypeEnum> ENUM_MAP;

    private ContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ContentTypeEnum getByCode(String code) {
        ContentTypeEnum result = ENUM_MAP.get(code);
        if (result == null) {
            return null;
        }
        return result;
    }

    public static boolean isContent(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.ARTICLE.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.ACTIVITY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.DAILY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.POSTER.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.AFTERNOON.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.EVENING.code);
    }

    public static boolean isPaper(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.DAILY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.AFTERNOON.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.EVENING.code);
    }

    public static boolean isMarket(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.OUTER_MARKET.code);
    }

    public static boolean isExclusive(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.OUTER_EXCLUSIVE.code);
    }

    public static boolean isSeller(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.SELLER.code);
    }

    static {
        ENUM_MAP = new HashMap<String, ContentTypeEnum>();
        for (ContentTypeEnum type : ContentTypeEnum.values()) {
            ENUM_MAP.put(type.getCode(), type);
        }
    }
}

