package cn.com.duiba.kjy.api.dto;

import cn.com.duiba.kjy.api.constant.ContentTypeEnum;
import cn.com.duiba.kjy.api.dto.exclusive.ExclusiveAreaItemDto;
import lombok.Data;
import lombok.ToString;

import java.util.Optional;

/**
 * Created by zhangshun on 2019/2/13.
 */
@Data
@ToString
public class SellerContentDto extends SellerContentSimpleDto {

    private UserDto userDto;

    private SellerDto sellerDto;

    private ContentDto contentDto;

    private ExclusiveAreaItemDto exclusiveAreaItemDto;

    private MarketAreaItemDto marketAreaItemDto;


    /**
     * 获取seller content title，不能简单使用content title
     * 要求所有seller内容都需要入库，不同的类型获取标题逻辑不同
     *
     * @param sellerContentDto
     * @return
     */
    public static String getTitle(SellerContentDto sellerContentDto) {
        if (ContentTypeEnum.isContent(sellerContentDto.getContentType())) {
            return Optional.ofNullable(sellerContentDto.getContentDto()).map(ContentDto::getTitle).orElse("");
        } else if (ContentTypeEnum.isExclusive(sellerContentDto.getContentType())) {
            return Optional.ofNullable(sellerContentDto.getExclusiveAreaItemDto()).map(ExclusiveAreaItemDto::getTitle).orElse("");
        } else if (ContentTypeEnum.isMarket(sellerContentDto.getContentType())) {
            return Optional.ofNullable(sellerContentDto.getMarketAreaItemDto()).map(MarketAreaItemDto::getTitle).orElse("");
        }
        return "";
    }

}
