package cn.com.duiba.kjy.api.dto.exclusive;

import cn.com.duiba.kjy.api.enums.exclusive.ExclusiveAreaItemStateEnum;
import cn.com.duiba.kjy.api.enums.exclusive.ExclusiveAreaItemTypeEnum;

import java.io.Serializable;

/**
* 专区内容表
*/
public class ExclusiveAreaItemDto implements Serializable {

    private static final long serialVersionUID = 6086053006660379419L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 文章、海报、活动ID或自定义链接等等
    */
    private String itemId;

    /**
    * 类型; article =文章、poster =海报 activity =活动 custom=自定义
     * @see ExclusiveAreaItemTypeEnum
    */
    private String itemType;

    /**
    * 内容标题
    */
    private String title;

    /**
    * 缩略图URL
    */
    private String mainImgUrl;

    /**
    * 排序
    */
    private Long sort;

    /**
     * 1=有效;2=无效
     * @see ExclusiveAreaItemStateEnum
     */
    private Integer state;

    /**
    * 专区ID
    */
    private Long exclusiveAreaId;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemId() {
        return itemId;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemType() {
        return itemType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    public void setMainImgUrl(String mainImgUrl) {
        this.mainImgUrl = mainImgUrl;
    }

    public String getMainImgUrl() {
        return mainImgUrl;
    }

    public void setSort(Long sort) {
        this.sort = sort;
    }

    public Long getSort() {
        return sort;
    }

    public void setExclusiveAreaId(Long exclusiveAreaId) {
        this.exclusiveAreaId = exclusiveAreaId;
    }

    public Long getExclusiveAreaId() {
        return exclusiveAreaId;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
}

