package cn.com.duiba.kjy.api.remoteservice;

/**
 * Created with IntelliJ IDEA.
 *
 * @author ChuanJiang
 * Date: 2019/7/3.
 * Time: 18:40.
 */

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.BlackListDto;
import cn.com.duiba.kjy.api.params.BlackListParam;

import java.util.List;

/**
 * 黑名单相关接口
 */
@AdvancedFeignClient
public interface RemoteBlackListService {
    /**
     * 插入活动黑名单记录
     * @param blackListParamList  {@link BlackListParam}
     * @return  成功条数
     */
    Integer addOrUpdateBlackList(List<BlackListParam> blackListParamList);
    /**
     * 根据活动Id查询所有相关黑名单列表
     * @param activityId 活动Id
     * @return List<BlackListDto> {@link BlackListDto} 黑名单列表
     */
    List<BlackListDto> getBlackListByActivityId(Long activityId);

    /**
     * 根据活动id和公司id返回黑名单列表
     * @param activityId 活动id
     * @param companyId  公司id
     * @return 黑名单列表
     */
    List<BlackListDto> getBlackListByActivityIdAndCompanyId(Long activityId,Long companyId);
}
