/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums;

import cn.com.duiba.kjy.api.util.NumberUtil;
import java.util.Objects;

public enum CompanyDocumentTypeEnum {
    WORD(1, "Word"),
    PPT(2, "PPT"),
    EXCEL(3, "Excel"),
    PDF(4, "PDF"),
    VIDEO(5, "\u7459\u55db\ue576"),
    PICTURE(6, "\u9365\u5267\u5896"),
    TXT(7, "\u93c2\u56e8\u6e70");

    private Integer type;
    private String typeName;

    private CompanyDocumentTypeEnum(Integer type, String typeName) {
        this.type = type;
        this.typeName = typeName;
    }

    public static CompanyDocumentTypeEnum getByType(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }
        for (CompanyDocumentTypeEnum typeEnum : CompanyDocumentTypeEnum.values()) {
            if (!Objects.equals(typeEnum.getType(), type)) continue;
            return typeEnum;
        }
        return null;
    }

    public Integer getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }
}

