/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.push;

import cn.com.duiba.kjy.api.enums.push.PushLabelEnum;
import java.util.Objects;

public enum PushEnum {
    DAILY(1, "\u6d60\u5a43\u68e9\u93c3\u2542\u59e4\u93c7\u5b58\u67ca"),
    AFTERNOON(2, "\u9357\u581d\u6097\u7487\u6fcb\ue57d\u93c7\u5b58\u67ca"),
    EVENING(3, "\u93c5\u6c2c\u7568\u8e47\u51ad\ue1e2\u93c7\u5b58\u67ca"),
    HOT_ARTICLE(4, "\u9416\u55d8\ue0d9\u9411\ue15f\u6783\u93ba\u3128\u5d18"),
    VISIT(5, "\u93b0\u5fd3\u609c\u7039\u3221\u57db\u93c9\u30e8\ue196"),
    DAILY_STATISTICS(6, "\u59e3\u5fd4\u68e9\u7039\u3221\u57db\u93c1\u7248\u5d41\u7f01\u71bb\ue178"),
    WEEKLY_STATISTICS(7, "\u59e3\u5fd3\u61c6\u7039\u3221\u57db\u93c1\u7248\u5d41\u7f01\u71bb\ue178"),
    DAILY_EARNINGS(8, "\u59e3\u5fd4\u68e9\u93c0\u5241\u6ced\u7f01\u71bb\ue178");

    private Integer pushType;
    private String pushName;

    private PushEnum(Integer pushType, String typeName) {
        this.pushType = pushType;
        this.pushName = typeName;
    }

    public static PushEnum getByPushType(Integer pushType) {
        if (Objects.isNull(pushType)) {
            return null;
        }
        for (PushEnum pushEnum : PushEnum.values()) {
            if (!Objects.equals(pushEnum.getPushType(), pushType)) continue;
            return pushEnum;
        }
        return null;
    }

    public Integer getLabel() {
        switch (this) {
            case DAILY: {
                return PushLabelEnum.MATERIAL.getLabel();
            }
            case AFTERNOON: {
                return PushLabelEnum.MATERIAL.getLabel();
            }
            case EVENING: {
                return PushLabelEnum.MATERIAL.getLabel();
            }
            case HOT_ARTICLE: {
                return PushLabelEnum.MATERIAL.getLabel();
            }
            case VISIT: {
                return PushLabelEnum.VISIT_ME.getLabel();
            }
            case DAILY_STATISTICS: {
                return PushLabelEnum.VISIT_ME.getLabel();
            }
            case WEEKLY_STATISTICS: {
                return PushLabelEnum.VISIT_ME.getLabel();
            }
            case DAILY_EARNINGS: {
                return PushLabelEnum.VIP_EXCLUSIVE.getLabel();
            }
        }
        return null;
    }

    public Integer getPushType() {
        return this.pushType;
    }

    public String getPushName() {
        return this.pushName;
    }
}

