/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.seller;

import java.util.Objects;

public enum SellerSpSwitchEnum {
    SITE_SALE_SWITCH_ON(SellerSpPositionEnum.SITE_SALE.getCode(), switchEnum.ON.getCode(), "\u4f1a\u9500\u7279\u6743\u5f00\u542f"),
    SITE_SALE_SWITCH_OFF(SellerSpPositionEnum.SITE_SALE.getCode(), switchEnum.OFF.getCode(), "\u4f1a\u9500\u7279\u6743\u5173\u95ed"),
    IMPORTANT_FIGURE_SWITCH_ON(SellerSpPositionEnum.IMPORTANT_FIGURE.getCode(), switchEnum.ON.getCode(), "\u91cd\u8981\u8282\u70b9\u5ba2\u6237\u5f00\u542f"),
    IMPORTANT_FIGURE_SWITCH_OFF(SellerSpPositionEnum.IMPORTANT_FIGURE.getCode(), switchEnum.OFF.getCode(), "\u91cd\u8981\u8282\u70b9\u5ba2\u6237\u5173\u95ed"),
    ENOUGH_COMMISSION_SWITCH_ON(SellerSpPositionEnum.ENOUGH_COMMISSION.getCode(), switchEnum.ON.getCode(), "\u6ee1\u989d\u8fd4\u4f63\u7279\u6743\u5f00\u542f"),
    ENOUGH_COMMISSION_SWITCH_OFF(SellerSpPositionEnum.ENOUGH_COMMISSION.getCode(), switchEnum.OFF.getCode(), "\u6ee1\u989d\u8fd4\u4f63\u7279\u6743\u5173\u95ed");

    private Integer position;
    private Integer switchValue;
    private String desc;

    private SellerSpSwitchEnum(Integer position, Integer switchValue, String desc) {
        this.position = position;
        this.switchValue = switchValue;
        this.desc = desc;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getDesc() {
        return this.desc;
    }

    public static SellerSpSwitchEnum getByPositionAndValue(int position, int switchValue) {
        for (SellerSpSwitchEnum c : SellerSpSwitchEnum.values()) {
            if (!Objects.equals(c.getPosition(), position) || !Objects.equals(c.getSwitchValue(), switchValue)) continue;
            return c;
        }
        return null;
    }

    public static int getSwitchValueByPositionAndDBValue(int position, Integer dBValue) {
        if (Objects.isNull(dBValue)) {
            return switchEnum.OFF.getCode();
        }
        return dBValue >> position - 1 & 1;
    }

    public Integer getSwitchValue() {
        return this.switchValue;
    }

    public static enum SellerSpPositionEnum {
        SITE_SALE(1, "\u4f1a\u9500\u7279\u6743"),
        IMPORTANT_FIGURE(2, "\u91cd\u8981\u8282\u70b9\u5ba2\u6237"),
        ENOUGH_COMMISSION(3, "\u6ee1\u989d\u8fd4\u4f63\u7279\u6743");

        private Integer code;
        private String desc;

        public Integer getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }

        private SellerSpPositionEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    public static enum switchEnum {
        ON(1, "\u5f00\u542f"),
        OFF(0, "\u5173\u95ed");

        private Integer code;
        private String desc;

        public Integer getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }

        private switchEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }
}

