package cn.com.duiba.kjy.api.dto.company;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhi
 * @date 2019/6/29 2:10 PM
 */
@Data
@ToString
public class CompanyDocumentDto implements Serializable {

    private static final long serialVersionUID = -5803500415636246043L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 资料名称
     */
    private String documentName;

    /**
     * 资料链接
     */
    private String documentUrl;

    /**
     * 资料类型
     * @see cn.com.duiba.kjy.api.enums.CompanyDocumentTypeEnum
     */
    private Integer documentType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;
}
