package cn.com.duiba.kjy.api.enums.push;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2019/6/25 11:18 AM
 */
public enum PushSwitchEnum {
    //销售员推送开启/关闭状态
    CLOSE(0, "关闭"),
    OPEN(1, "开启"),
    ;

    private int code;

    private String desc;

    PushSwitchEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PushSwitchEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (PushSwitchEnum pushSwitchEnum : values()) {
            if (Objects.equals(pushSwitchEnum.getCode(), code)) {
                return pushSwitchEnum;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
