package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Set;

/**
 * 推送开关配置服务类
 * @author lizhi
 * @date 2019/6/24 2:58 PM
 */
@AdvancedFeignClient
public interface RemoteSellerPushSwitchService {

    /**
     * 销售员该推送是否关闭
     * @param sellerId 销售员ID
     * @param pushType 推送类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     * @return true-关闭，false-未关闭
     */
    Boolean isClose(Long sellerId, Integer pushType);

    /**
     * 获取关闭该推送的所有销售员
     * @deprecated 已废弃，请使用
     * @param pushType 推送类型 getCloseSellerIdByPushTypeAndSeller
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     * @return 销售员ID集合
     */
    @Deprecated
    Set<Long> getCloseSellerIdByPushType(Integer pushType);

    /**
     * 获取给定销售员中关闭该推送的销售员
     * @param pushType 推送类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     * @param sellerIds 给定销售员ID集合
     * @return 销售员ID集合
     */
    Set<Long> getCloseSellerIdByPushTypeAndSeller(Integer pushType, List<Long> sellerIds);

    /**
     * 获取销售员关闭的所有推送
     * @param sellerId 销售员ID
     * @return 该销售员关闭的所有推送类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     */
    Set<Integer> getClosePushTypesBySellerId(Long sellerId);

    /**
     * 销售员开启/关闭推送
     * @param sellerId 销售员ID
     * @param pushType 推送类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     * @param pushSwitch 开启/关闭
     * @see cn.com.duiba.kjy.api.enums.push.PushSwitchEnum
     * @return
     */
    Boolean closeOrOpenPush(Long sellerId, Integer pushType, Integer pushSwitch);
}
