package cn.com.duiba.kjy.api.enums.seller;

import java.util.Objects;

/**
 * 销售员导入任务状态
 * @author lizhi
 * @date 2019-06-04
 */
public enum SellerImportTaskStatusEnum {

    //状态：1=未执行、2=执行中、3=调用失败、4=执行失败、5=执行成功、6=完成
    UN_EXECUTED(1, "未执行"),
    EXECUTING(2, "执行中"),
    CALL_FAILED(3, "调用失败"),
    EXEC_FAILED(4, "执行失败"),
    EXEC_SUCCESS(5, "执行成功"),
    COMPLETE(6, "完成");

    private Integer code;

    private String desc;

    SellerImportTaskStatusEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static SellerImportTaskStatusEnum getByCode(Integer code) {
        for (SellerImportTaskStatusEnum enumVal : SellerImportTaskStatusEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        SellerImportTaskStatusEnum statusEnum = getByCode(code);
        if (Objects.isNull(statusEnum)) {
            return "";
        }
        return statusEnum.getDesc();
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
