package cn.com.duiba.kjy.api.enums.seller;

/**
 * 销售员会员类型
 * @author zhanghuifeng
 * date 2019-06-18-14:22
 */
public enum SellerVipTypeEnum {
    ORDINARY(1, "普通会员"),
    PAY(2, "付费会员"),
    PRIVILEGE_VIP(3, "特权会员"),
    ;
    private Integer code;

    private String desc;

    SellerVipTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static SellerVipTypeEnum getByCode(Integer code) {
        for (SellerVipTypeEnum enumVal : SellerVipTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (SellerVipTypeEnum enumVal : SellerVipTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
