package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerPermissionDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.seller.SellerPermissionParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019/7/18 18:54
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerPermissionService {

    /**
     * 获取权限状态
     * @param permissionCode
     * @return 0 全部开启 1 全部关闭 2 部分开启
     */
    Integer getSellerPermissionStatus(String permissionCode);

    /**
     * 分页查询拥有权限代理人列表
     * @param query
     * @return
     */
    Page<SellerPermissionDto> findPage(SellerPermissionParam query);

    /**
     * 新增或更新代理人权限
     * @param sellerIds
     * @param permissionCode
     * @param isHalted
     * @return
     */
    Integer addOrUpdateSellerPermission(List<Long> sellerIds, String permissionCode, Integer isHalted);

    /**
     * 判断是否代理人是否有权限
     * @param permissionCode
     * @param sellerId
     * @return
     */
    Boolean isSellerHasPermission(String permissionCode, Long sellerId);

}
