package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.CustDto;
import cn.com.duiba.kjy.api.dto.SellerCustomerDto;
import cn.com.duiba.kjy.api.params.EditCustomerParam;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SearchCustomerParam;

import java.util.List;
import java.util.Map;

/**
 * @author linjianhui
 * @description  销售客户信息服务
 * @date 2019-02-17 22:38
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerService {

    /**
     * 根据销售员ID和用户ID查询
     * @param sellerId 销售员ID
     * @param userId 用户ID
     * @return
     */
    SellerCustomerDto findBySellerAndUser(Long sellerId, Long userId);

    /**
     * 根据销售员ID和用户ID查询
     * @param sellerId 销售员ID
     * @param nickname 微信用户昵称
     * @return
     */
    SellerCustomerDto findBySellerAndNickname(Long sellerId, String nickname);


    /**
     * 通过主键id查询客户信息（销售员客户关联ID）
     * @param id
     * @return
     */
    SellerCustomerDto findById(Long id);

    /**
     * 通过销售id和用户id列表，查询客户列表
     * @param sellerId
     * @param sellerId
     * @return
     */
    List<SellerCustomerDto> findBySellerIdAndUserIds(Long sellerId,List<Long> userIds);

    /**
     * 根据参数查询客户列表
     * @param param
     * @return
     */
    Page<SellerCustomerDto> findSellerCustomer(SearchCustomerParam param);

    /**
     * 编辑客户信息
     * @param param
     * @return
     */
    Integer updateSellerCustomer(EditCustomerParam param);

    /**
     * 加为客户
     * @param param
     * @return 返回客户ID
     */
    Long addSellerCustomer(EditCustomerParam param);

    /**
     * 添加中奖人
     * @param param
     * @return 返回客户ID
     */
    CustDto addWinner(EditCustomerParam param);


    /**
     * 删除中奖人
     * @param custIds
     * @return
     */
    Boolean delWinner(String custIds);

    /**
     * 更新客户最后访问时间
     * @param sellerId
     * @param userId
     * @return
     */
    Boolean updateLastVisitTime(Long sellerId, Long userId);

    Boolean updateVisitCountIncrease(Long sellerId, Long userId);

    /**
     *
     * @param idList
     * @return
     */
    List<SellerCustomerDto> findByIds(List<Long> idList);

    /**
     * 查询总数
     * @return
     */
    Integer getSellerCustomerCountByParam(SearchCustomerParam param);

    /**
     * 返回 用户id为主键的Map
     * @param sellerId
     * @param userIds
     * @return
     */
    Map<Long, SellerCustomerDto> getSellerCustomerMap(Long sellerId, List<Long> userIds);
}
