/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.enums.push.PushEventEnum;
import cn.com.duiba.kjy.api.enums.push.PushMessageTypeEnum;
import cn.com.duiba.kjy.api.util.IdMakerUtil;
import cn.com.duiba.wolf.utils.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class PushEmbedUtils {
    private static String getPushParam(Map<String, String[]> parameterMap) {
        if (MapUtils.isEmpty(parameterMap)) {
            return "";
        }
        Map<String, String> params = PushEmbedUtils.getPushParamMap(null, null, null, null, null);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String[] param = parameterMap.get(key);
            if (!PushEmbedUtils.isNotEmpty(param)) continue;
            params.put(key, param[0]);
        }
        return UrlUtils.buildURLParams(params);
    }

    private static boolean isNotEmpty(String[] param) {
        return Objects.nonNull(param) && param.length > 0;
    }

    public static String getPushParam(Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        Map<String, String> pushParamMap = PushEmbedUtils.getPushParamMap(oaId, eventEnum, messageTypeEnum, urlOrder, dpm);
        return UrlUtils.buildURLParams(pushParamMap);
    }

    public static String getEncodePushParam(Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        return PushEmbedUtils.encode(PushEmbedUtils.getPushParam(oaId, eventEnum, messageTypeEnum, urlOrder, dpm));
    }

    public static String buildPushParam(String url, Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        Map<String, String> params = PushEmbedUtils.getPushParamMap(oaId, eventEnum, messageTypeEnum, urlOrder, dpm);
        int index = url.indexOf("?");
        if (index < 0) {
            return UrlUtils.appendParams((String)url, params);
        }
        Map map = UrlUtils.uRLRequest((String)url);
        if (MapUtils.isEmpty((Map)map)) {
            return UrlUtils.appendParams((String)url, params);
        }
        String uriUrl = (String)map.get("uri");
        if (StringUtils.isBlank((String)uriUrl)) {
            return UrlUtils.appendParams((String)url, params);
        }
        String decode = PushEmbedUtils.decode(uriUrl);
        String decodePushUrl = UrlUtils.appendParams((String)decode, params);
        map.put("uri", PushEmbedUtils.encode(decodePushUrl));
        return UrlUtils.appendParams((String)UrlUtils.urlPage((String)url), (Map)map);
    }

    private static Map<String, String> getPushParamMap(Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        String oaIdStr = Objects.isNull(oaId) ? "0" : IdMakerUtil.encodingId(oaId);
        String eventEnumStr = Objects.isNull((Object)eventEnum) ? "" : eventEnum.getEventType();
        String messageTypeEnumStr = Objects.isNull((Object)messageTypeEnum) ? "0" : String.valueOf(messageTypeEnum.getType());
        String urlOrderStr = Objects.isNull(urlOrder) ? "0" : String.valueOf(urlOrder);
        params.put("push", "push");
        params.put("oa_id", oaIdStr);
        params.put("push_id", eventEnumStr);
        params.put("message_type", messageTypeEnumStr);
        params.put("url_order", urlOrderStr);
        params.put("access_source", String.valueOf(1));
        if (StringUtils.isNotBlank((String)dpm)) {
            params.put("dpm", dpm);
        }
        return params;
    }

    private static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    private static String decode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }
}

