package cn.com.duiba.kjy.api.remoteservice.accurateTag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.tag.ItemTagDto;
import cn.com.duiba.kjy.api.dto.tag.ItemTagExtDto;

import java.util.List;
import java.util.Map;

/**
 * item和标签关联关系service
 * @author zhanghuifeng
 * date 2019-04-11-15:11
 */
@AdvancedFeignClient
public interface RemoteItemAccurateTagService {

    /**
     * 根据标签集合获取存在的标签集合
     * @param tagIds
     * @return
     */
    List<Long> findExitTagIdsByTagIds(List<Long> tagIds);

    Map<Long/*contentId*/, Map<Integer/*level*/, List<ItemTagExtDto>>> findTagByItemIds(List<Long> itemIdList);
	
	/**
     * 根据itemId集合获取
     * @param itemIds
     * @param itemType @see TagItemTypeEnum
     * @return
     */
    List<ItemTagDto> findByItemIds(List<Long> itemIds, Integer itemType);

    /**
     * 根据标签获取文章列表
     * @param tag
     * @param pageNo
     * @param pageSize
     * @return
     */
    List<Long> pageContent(Long tag,Long companyId,Integer pageNo,Integer pageSize);


    /**
     * 根据素材ID获取一级标签ID
     * @param contentId
     * @return
     */
    Long  getFristTagId(Long contentId);
}
