package cn.com.duiba.kjy.api.enums.push;

/**
 * 推送事件
 * @author lizhi
 * @date 2019/7/10 3:21 PM
 */
public enum  PushEventEnum {

    //推送事件类型， 推送类型
    //推送事件类型（S1、S2...），一定要产品定义！！！
    SUBSCRIBE_WELCOME("S1","关注公众号"),
    SUBSCRIBE_FROM_CONTENT("S2","通过内容页二维码关注公众号"),
    SUBSCRIBE_RECOMMEND("S3","新用户引导转发文章"),
    SCAN_PROM("S4","会销五折优惠码"),
    ACTIVATION("S5","开通会员"),
    VISIT_FIRST("S6","内容第一次访客来访"),
    VISIT_NON_FIRST("S7","内容非第一次访客来访"),
    ACTIVITY_FORM_SUBMIT("S8","活动表单提交"),
    PREFERENTIAL_INFORMATION("S9","优惠信息推送"),
    PRIVATE_CHAT_ACCESS("S10","进入聊天界面通知"),
    PRIVATE_CHAT_SEND("S11","聊天通知"),
    NON_SUBSCRIBE_VIP("D1","引导关注客集集VIP"),
    STATISTICS_DAY("D3","每日访问数据统计"),
    STATISTICS_WEEK("D4","每周访问数据统计"),
    DAILY("D5","早报推送"),
    EVENING("D6","晚安心语"),
    HOT_CONTENT("D7","热门文章"),
    DISTRIBUTION("V1","已邀请好友关注"),
    REWARDED("V2","获得奖励提醒"),
    ARRIVAL_ACCOUNT("V3","提现到账通知"),
    STATISTICS_VIP_INCOME("V4","每日收益推送"),
    INTERACTIVE_PUSH("S12","互动推送"),
    AFTERNOON_ACTIVITY("D8","下午动画推荐"),
    SELLER_CARD_REAL_TIME_PUSH("S13","名片实时推送"),
    FORWARD_CONTENT_PUSH("S14","客户转发素材通知"),
    FORWARD_SELLER_CARD_PUSH("S15","客户转发名片通知"),
    ACTIVITY_FORM_SUBMIT_NON_REAL_TIME("S17","活动表单提交-非实时"),
    ACTIVITY_FORM_SUBMIT_LOTTERY("S18","活动中奖"),
    WEEKLY_THUMBS_UP("S19","周报点赞"),
    MID_AUTUMN_BLESSING("S21","中秋祝福通知"),
    LIKE_CONTENT_INTERACTION("S22","素材点赞通知"),
    LIKE_CARD_INTERACTION("S23","名片点赞通知"),
    SUBSCRIBE_VIP_NOVICE_TASK("V7", "关注公众号新人任务"),
    ACTIVITY_FORM_HAS_SOURCE("S24", "有内容来源的活动表单提交"),
    NATIONAL_DAY_BLESSING("S25","国庆祝福通知"),
    NATIONAL_DAY_WELCOME("S26","通过国庆活动关注公众号欢迎语"),
    NATIONAL_DAY_ACTIVITY("S27","通过国庆活动关注公众号推送定制活动"),
    RECEIVE_INSURANCE("S31","私信领取赠险"),
    CLICK_CONTACT_PHONE("S28","点击电话联系"),
    CLICK_CONTACT_WX("S29","点击微信联系"),
    READING("S30","阅读完成"),
    CLICK_CONTACT("S32","点联系TA"),
    LIKE_CARD_INTERACTION_FROM_OTHER("S33","来自其它素材页的名片点赞通知"),
    SALES_PROMOTION_REMIND("S34","会销优惠结束前2小时，优惠提醒"),
    SALES_PROMOTION_CASE("S35","会销优惠结束48小时后，推送客集集案例"),
    SALES_PROMOTION("S36","会销优惠结束48小时后，推送限时优惠"),
    INVESTMENT_INVESTMENT_TIMING_CONTENT_PUSH1("S37", "定时推送文章1"),
    INVESTMENT_INVESTMENT_TIMING_CONTENT_PUSH2("S38", "定时推送文章2"),
    INCREASE_USER_CLUE_ACTIVITY("S39", "获得增员线索（小游戏）"),
    INVESTMENT_CLUE_ACTIVITY("S40", "获得投资线索（小游戏）"),
    INCREASE_USER_CLUE_ARTICLE("S41", "获得增员线索（文章）"),
    INVESTMENT_CLUE_ARTICLE("S42", "获得投资线索（文章）"),
    INVESTMENT_INVESTMENT_TIMING_CONTENT_PUSH3("S43", "定时推送文章3"),
    SINGLE_FESTIVAL_WELCOME("S44","通过双十一活动关注公众号欢迎语"),
    SINGLE_FESTIVAL_ACTIVITY("S45","通过双十一活动关注公众号推送定制活动"),
    SINGLE_FESTIVAL_DAILY_PUSH("S46","双十一活动定时推送"),
    ACCURATE_MATERIAL_PUSH("S47","精准素材推送"),
    ACTIVITY_ACCURATE_MATERIAL_PUSH("S49","活动精准素材推送"),


    ;

    /**
     * 推送事件类型（值为推送需求中的推送ID）
     */
    private String eventType;

    /**
     * 推送事件描述
     */
    private String desc;

    PushEventEnum(String eventType, String desc) {
        this.eventType = eventType;
        this.desc = desc;
    }

    public String getEventType() {
        return eventType;
    }

    public String getDesc() {
        return desc;
    }
}
