package cn.com.duiba.kjy.api.params;

import cn.com.duiba.kjy.api.enums.order.IsPaidEnum;
import cn.com.duiba.kjy.api.enums.seller.SellerVipTypeEnum;
import cn.com.duiba.kjy.api.params.seller.SellerSpTypeParams;
import lombok.Data;
import lombok.ToString;

import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2019-02-15 18:01
 * @description: 查询会员参数
 */
@Data
@ToString
public class SearchVipSellerParam extends PageQuery{

    private static final long serialVersionUID = -3960523453033727411L;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 销售员昵称
     */
    private String sellerName;

    /**
     * 销售员手机号
     */
    private String phoneNumber;

    /**
     * vip级别，0=不是、1=是
     */
    private Integer vip;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 公司ID
     */
    private Long companyId;

    private List<SellerSpTypeParams> spTypeParams;

    /**
     * 会员类型
     * @see SellerVipTypeEnum
     */
    private Integer vipType;

    /**
     * 是否付费
     * @see IsPaidEnum
     */
    private Integer isPaid;
}
