/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.push;

import cn.com.duiba.kjy.api.enums.push.PushLabelEnum;
import java.util.Objects;

public enum PushEnum {
    DAILY(1, "\u4eca\u65e5\u65e9\u62a5\u66f4\u65b0"),
    AFTERNOON(2, "\u5348\u540e\u8bdd\u9898\u66f4\u65b0"),
    EVENING(3, "\u665a\u5b89\u5fc3\u8bed\u66f4\u65b0"),
    HOT_ARTICLE(4, "\u7206\u6b3e\u70ed\u6587\u63a8\u8350"),
    VISIT(5, "\u610f\u5411\u5ba2\u6237\u6765\u8bbf"),
    DAILY_STATISTICS(6, "\u6bcf\u65e5\u5ba2\u6237\u6570\u636e\u7edf\u8ba1"),
    WEEKLY_STATISTICS(7, "\u6bcf\u5468\u5ba2\u6237\u6570\u636e\u7edf\u8ba1"),
    DAILY_EARNINGS(8, "\u6bcf\u65e5\u6536\u76ca\u7edf\u8ba1");

    private Integer pushType;
    private String pushName;

    private PushEnum(Integer pushType, String typeName) {
        this.pushType = pushType;
        this.pushName = typeName;
    }

    public static PushEnum getByPushType(Integer pushType) {
        if (Objects.isNull(pushType)) {
            return null;
        }
        for (PushEnum pushEnum : PushEnum.values()) {
            if (!Objects.equals(pushEnum.getPushType(), pushType)) continue;
            return pushEnum;
        }
        return null;
    }

    public Integer getLabel() {
        switch (this) {
            case DAILY: {
                return PushLabelEnum.MATERIAL.getLabel();
            }
            case AFTERNOON: {
                return PushLabelEnum.MATERIAL.getLabel();
            }
            case EVENING: {
                return PushLabelEnum.MATERIAL.getLabel();
            }
            case HOT_ARTICLE: {
                return PushLabelEnum.MATERIAL.getLabel();
            }
            case VISIT: {
                return PushLabelEnum.VISIT_ME.getLabel();
            }
            case DAILY_STATISTICS: {
                return PushLabelEnum.VISIT_ME.getLabel();
            }
            case WEEKLY_STATISTICS: {
                return PushLabelEnum.VISIT_ME.getLabel();
            }
            case DAILY_EARNINGS: {
                return PushLabelEnum.VIP_EXCLUSIVE.getLabel();
            }
        }
        return null;
    }

    public Integer getPushType() {
        return this.pushType;
    }

    public String getPushName() {
        return this.pushName;
    }
}

