/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.constant.KjyRuntimeException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class SellerIdConverter {
    public static Long encode(Long sellerId) {
        if (Objects.isNull(sellerId)) {
            throw new KjyRuntimeException("\u9500\u552eID\u4e3a\u7a7a,\u65e0\u6cd5\u83b7\u53d6\u4f1a\u5458ID");
        }
        if (sellerId > 999999L) {
            throw new KjyRuntimeException("\u9500\u552eID\u6700\u5927\u652f\u6301999999");
        }
        String sellerIdStr = String.valueOf(sellerId);
        int length = sellerIdStr.length();
        int replaceLength = 6 - length;
        String replaceStr = SellerIdConverter.getReplaceStr(replaceLength, sellerIdStr);
        return Long.valueOf(length + replaceStr + sellerIdStr);
    }

    private static String getReplaceStr(int replaceLength, String sellerIdStr) {
        if (replaceLength == 0) {
            return "";
        }
        int start = Integer.valueOf(sellerIdStr.substring(sellerIdStr.length() - 1));
        StringBuilder sb = new StringBuilder();
        for (int i = replaceLength; i > 0; --i) {
            int replaceNum = start * start + i;
            start = SellerIdConverter.getUnits(replaceNum);
            sb.append(start);
        }
        return sb.toString();
    }

    private static int getUnits(int num) {
        return num > 9 ? num % 10 : num;
    }

    public static Long decode(Long sourceMemberId) {
        return SellerIdConverter.validate(sourceMemberId) ? SellerIdConverter.innerDecode(sourceMemberId + "") : -1L;
    }

    private static Long innerDecode(String memberId) {
        int length = Integer.valueOf(memberId.substring(0, 1));
        int replaceLength = 7 - length;
        return Long.valueOf(memberId.substring(replaceLength, 7));
    }

    public static boolean validate(Long sourceMemberId) {
        String memberId = sourceMemberId + "";
        if (StringUtils.isEmpty((String)memberId) || memberId.length() != 7) {
            return false;
        }
        Long realSellerId = SellerIdConverter.innerDecode(memberId);
        return sourceMemberId.equals(SellerIdConverter.encode(realSellerId));
    }
}

