/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.enums.push.PushEventEnum;
import cn.com.duiba.kjy.api.enums.push.PushMessageTypeEnum;
import cn.com.duiba.kjy.api.util.IdMakerUtil;
import cn.com.duiba.wolf.utils.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class PushEmbedUtils {
    public static String getPushParam(Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        Map<String, String> pushParamMap = PushEmbedUtils.getPushParamMap(oaId, eventEnum, messageTypeEnum, urlOrder, dpm);
        return UrlUtils.buildURLParams(pushParamMap);
    }

    public static String getPushParam(Map<String, String[]> parameterMap) {
        Map<String, String> pushParamMap = PushEmbedUtils.getPushParamMap(parameterMap);
        return UrlUtils.buildURLParams(pushParamMap);
    }

    public static String getEncodePushParam(Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        return PushEmbedUtils.encode(PushEmbedUtils.getPushParam(oaId, eventEnum, messageTypeEnum, urlOrder, dpm));
    }

    public static String buildPushParam(String url, Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        Map<String, String> params = PushEmbedUtils.getPushParamMap(oaId, eventEnum, messageTypeEnum, urlOrder, dpm);
        int index = url.indexOf("?");
        if (index < 0) {
            return UrlUtils.appendParams((String)url, params);
        }
        Map map = UrlUtils.uRLRequest((String)url);
        if (MapUtils.isEmpty((Map)map)) {
            return UrlUtils.appendParams((String)url, params);
        }
        String uriUrl = (String)map.get("uri");
        if (StringUtils.isBlank((String)uriUrl)) {
            return UrlUtils.appendParams((String)url, params);
        }
        String decode = PushEmbedUtils.decode(uriUrl);
        String decodePushUrl = UrlUtils.appendParams((String)decode, params);
        map.put("uri", PushEmbedUtils.encode(decodePushUrl));
        return UrlUtils.appendParams((String)UrlUtils.urlPage((String)url), (Map)map);
    }

    public static String buildPushParam(String url, Map<String, String[]> parameterMap) {
        Map<String, String> pushParamMap = PushEmbedUtils.getPushParamMap(parameterMap);
        return UrlUtils.appendParams((String)url, pushParamMap);
    }

    private static Map<String, String> getPushParamMap(Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        String pushId = Objects.isNull((Object)eventEnum) ? null : eventEnum.getEventType();
        Integer messageType = Objects.isNull((Object)messageTypeEnum) ? null : messageTypeEnum.getType();
        return PushEmbedUtils.getPushParamMap(oaId, pushId, messageType, urlOrder, dpm);
    }

    private static Map<String, String> getPushParamMap(Long oaId, String pushId, Integer messageType, Integer urlOrder, String dpm) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("push", "push");
        if (Objects.nonNull(oaId)) {
            params.put("oa_id", IdMakerUtil.encodingId(oaId));
        }
        if (Objects.nonNull(pushId)) {
            params.put("push_id", pushId);
        }
        if (Objects.nonNull(messageType)) {
            params.put("message_type", String.valueOf(messageType));
        }
        if (Objects.nonNull(urlOrder)) {
            params.put("url_order", String.valueOf(urlOrder));
        }
        params.put("access_source", String.valueOf(1));
        if (StringUtils.isNotBlank((String)dpm)) {
            params.put("dpm", dpm);
        }
        return params;
    }

    public static Map<String, String> getPushParamMap(Map<String, String[]> parameterMap) {
        if (MapUtils.isEmpty(parameterMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        Set<String> pushKey = PushEmbedUtils.getPushParamMap((Long)0L, "", 0, (Integer)0, null).keySet();
        for (String key : pushKey) {
            String[] param = parameterMap.get(key);
            if (!PushEmbedUtils.isNotEmpty(param)) continue;
            params.put(key, param[0]);
        }
        return params;
    }

    private static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    private static String decode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    private static boolean isNotEmpty(String[] param) {
        return Objects.nonNull(param) && param.length > 0;
    }
}

