/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.constant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public enum ContentTypeEnum {
    ARTICLE("article", "\u6587\u7ae0"),
    ACTIVITY("activity", "\u6d3b\u52a8"),
    DAILY("daily", "\u65e9\u62a5"),
    POSTER("poster", "\u6d77\u62a5"),
    AFTERNOON("afternoon", "\u5348\u540e\u8bdd\u9898"),
    EVENING("evening", "\u665a\u5b89\u5fc3\u8bed"),
    SELLER("seller", "\u9500\u552e\u5458\u540d\u7247"),
    OUTER_MARKET("outer_market", "\u8170\u5c01\u81ea\u5b9a\u4e49\u94fe\u63a5"),
    OUTER_EXCLUSIVE("outer_exclusive", "\u4e13\u533a\u81ea\u5b9a\u4e49\u94fe\u63a5"),
    ACTIVITY_EXT_01("activity_01", "\u62bd\u5956"),
    ACTIVITY_EXT_02("activity_02", "\u6d4b\u8bd5"),
    ACTIVITY_EXT_03("activity_03", "\u7b54\u9898"),
    ACTIVITY_EXT_04("activity_04", "\u591a\u9875\u52a8\u753b"),
    ACTIVITY_EXT_05("activity_05", "\u5355\u9875\u52a8\u753b");

    private String code;
    private String desc;
    private static final Map<String, ContentTypeEnum> ENUM_MAP;

    private ContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ContentTypeEnum getByCode(String code) {
        ContentTypeEnum result = ENUM_MAP.get(code);
        if (result == null) {
            return null;
        }
        return result;
    }

    public static boolean isActivity(String type) {
        ContentTypeEnum typeEnum = ContentTypeEnum.getByCode(type);
        return ContentTypeEnum.isActivity(typeEnum);
    }

    public static boolean isActivity(ContentTypeEnum typeEnum) {
        if (typeEnum == null) {
            return false;
        }
        return typeEnum.code.startsWith("activity");
    }

    public static String getContentTypeLike(String type) {
        ContentTypeEnum typeEnum = ContentTypeEnum.getByCode(type);
        if (typeEnum == null) {
            return null;
        }
        if (ContentTypeEnum.isActivity(typeEnum)) {
            return ContentTypeEnum.getActivityLike();
        }
        return type;
    }

    public static String getActivityLike() {
        return "activity%";
    }

    public static List<ContentTypeEnum> getActivityExtTypes() {
        ArrayList<ContentTypeEnum> contentTypeEnums = new ArrayList<ContentTypeEnum>();
        for (ContentTypeEnum typeEnum : ContentTypeEnum.values()) {
            if (!typeEnum.code.startsWith("activity_")) continue;
            contentTypeEnums.add(typeEnum);
        }
        return contentTypeEnums;
    }

    public static boolean isContent(String type) {
        ContentTypeEnum typeEnum = ContentTypeEnum.getByCode(type);
        if (typeEnum == null) {
            return false;
        }
        return Objects.equals((Object)typeEnum, (Object)ARTICLE) || ContentTypeEnum.isActivity(typeEnum) || Objects.equals((Object)typeEnum, (Object)DAILY) || Objects.equals((Object)typeEnum, (Object)POSTER) || Objects.equals((Object)typeEnum, (Object)AFTERNOON) || Objects.equals((Object)typeEnum, (Object)EVENING);
    }

    public static boolean isPaper(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.DAILY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.AFTERNOON.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.EVENING.code);
    }

    public static boolean isMarket(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.OUTER_MARKET.code);
    }

    public static boolean isExclusive(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.OUTER_EXCLUSIVE.code);
    }

    public static boolean isSeller(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.SELLER.code);
    }

    static {
        ENUM_MAP = new HashMap<String, ContentTypeEnum>();
        for (ContentTypeEnum type : ContentTypeEnum.values()) {
            ENUM_MAP.put(type.getCode(), type);
        }
    }
}

