/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.lottery;

import cn.com.duiba.kjy.api.util.BitUtils;
import cn.com.duiba.kjy.api.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public enum MiddlePageSwitchEnum {
    ADD_WINNER_PAGE(0, "\u6307\u5b9a\u4e2d\u5956\u4eba\u9875\u9762"),
    CHOOSE_COUPON_PAGE(1, "\u9009\u62e9\u4f18\u60e0\u5238\u9875\u9762");

    private Integer type;
    private String desc;

    private MiddlePageSwitchEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static Integer addPage(Integer middlePageSwitch, MiddlePageSwitchEnum switchEnum2) {
        if (middlePageSwitch == null || switchEnum2 == null) {
            return null;
        }
        return (int)BitUtils.addBit(middlePageSwitch.intValue(), switchEnum2.getType());
    }

    public static Integer removePage(Integer middlePageSwitch, MiddlePageSwitchEnum switchEnum2) {
        if (middlePageSwitch == null || switchEnum2 == null) {
            return null;
        }
        return (int)BitUtils.removeBit(middlePageSwitch.intValue(), switchEnum2.getType());
    }

    public static boolean hasPage(Integer middlePageSwitch, MiddlePageSwitchEnum switchEnum2) {
        if (middlePageSwitch == null || switchEnum2 == null) {
            return false;
        }
        return BitUtils.isTrue(middlePageSwitch.intValue(), switchEnum2.getType());
    }

    public static List<Integer> getPages(Integer middlePageSwitch) {
        if (NumberUtil.isNullOrLteZero(middlePageSwitch)) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> pages = new ArrayList<Integer>();
        for (MiddlePageSwitchEnum switchEnum2 : MiddlePageSwitchEnum.values()) {
            if (!MiddlePageSwitchEnum.hasPage(middlePageSwitch, switchEnum2)) continue;
            pages.add(switchEnum2.getType());
        }
        return pages;
    }

    public static int getMiddlePageSwitch(List<Integer> pages) {
        if (CollectionUtils.isEmpty(pages)) {
            return 0;
        }
        int middlePageSwitch = 0;
        for (Integer page : pages) {
            MiddlePageSwitchEnum switchEnum2 = MiddlePageSwitchEnum.getByType(page);
            if (switchEnum2 == null) continue;
            middlePageSwitch = MiddlePageSwitchEnum.addPage(middlePageSwitch, switchEnum2);
        }
        return middlePageSwitch;
    }

    public static MiddlePageSwitchEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (MiddlePageSwitchEnum switchEnum2 : MiddlePageSwitchEnum.values()) {
            if (!switchEnum2.getType().equals(type)) continue;
            return switchEnum2;
        }
        return null;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }
}

