package cn.com.duiba.kjy.api.constant;


import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Created by zhangshun on 2019/2/13.
 */
public enum ContentTypeEnum {

    /**
     * 内容类型
     */
    ARTICLE("article", "文章"),
    ACTIVITY("activity", "活动"),
    DAILY("daily", "早报"),
    POSTER("poster", "海报"),
    AFTERNOON("afternoon", "午后话题"),
    EVENING("evening", "晚安心语"),

    // 访问记录的类型
    SELLER("seller", "销售员名片"),
    OUTER_MARKET("outer_market", "腰封自定义链接"),
    OUTER_EXCLUSIVE("outer_exclusive", "专区自定义链接"),

    //活动扩展类型
    ACTIVITY_EXT_01("activity_01", "抽奖"),
    ACTIVITY_EXT_02("activity_02", "测试"),
    ACTIVITY_EXT_03("activity_03", "答题"),
    ACTIVITY_EXT_04("activity_04", "多页动画"),
    ACTIVITY_EXT_05("activity_05", "单页动画"),
    ;

    private String code;
    private String desc;

    ContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, ContentTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ContentTypeEnum type : values()){
            ENUM_MAP.put(type.getCode(), type);
        }
    }

    public static ContentTypeEnum getByCode(String code){
        ContentTypeEnum result = ENUM_MAP.get(code);
        if(result == null){
           return null;
        }
        return result;
    }

    public static boolean isActivity(String type) {
        ContentTypeEnum typeEnum = getByCode(type);
        return isActivity(typeEnum);
    }

    public static boolean isActivity(ContentTypeEnum typeEnum) {
        if (typeEnum == null) {
            return false;
        }
        return typeEnum.code.startsWith("activity");
    }

    public static String getContentTypeLike(String type) {
        ContentTypeEnum typeEnum = getByCode(type);
        if (typeEnum == null) {
            return null;
        }
        if (isActivity(typeEnum)) {
            return getActivityLike();
        }
        return type;
    }

    public static String getActivityLike() {
        return "activity%";
    }

    public static List<ContentTypeEnum> getActivityExtTypes() {
        List<ContentTypeEnum> contentTypeEnums = new ArrayList<>();
        for (ContentTypeEnum typeEnum : values()) {
            if (typeEnum.code.startsWith("activity_")) {
                contentTypeEnums.add(typeEnum);
            }
        }
        return contentTypeEnums;
    }

    public static boolean isContent(String type) {
        ContentTypeEnum typeEnum = getByCode(type);
        if (typeEnum == null) {
            return false;
        }
        return Objects.equals(typeEnum, ARTICLE) ||
                isActivity(typeEnum) ||
                Objects.equals(typeEnum, DAILY) ||
                Objects.equals(typeEnum, POSTER) ||
                Objects.equals(typeEnum, AFTERNOON) ||
                Objects.equals(typeEnum, EVENING)
                ;
    }

    public static boolean isPaper(String type) {
        return StringUtils.equals(type, DAILY.code) ||
                StringUtils.equals(type, AFTERNOON.code) ||
                StringUtils.equals(type, EVENING.code)
                ;
    }

    public static boolean isMarket(String type) {
        return StringUtils.equals(type, OUTER_MARKET.code);
    }

    public static boolean isExclusive(String type) {
        return StringUtils.equals(type, OUTER_EXCLUSIVE.code);
    }

    public static boolean isSeller(String type) {
        return StringUtils.equals(type, SELLER.code);
    }

}
