package cn.com.duiba.kjy.api.enums.lottery;

/**
 * @author lizhi
 * @date 2019/8/16 4:27 PM
 */
public enum LotteryOrderStateEnum {

    NON_LOTTERY(0, "未出奖"),
    LOTTERY(1, "出奖中"),
    LOTTERY_SUCCESS(2, "出奖成功"),
    LOTTERY_FAIL(3, "出奖异常"),
    ;

    private Integer type;

    private String desc;

    LotteryOrderStateEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static LotteryOrderStateEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (LotteryOrderStateEnum stateEnum : values()) {
            if (stateEnum.getType().equals(type)) {
                return stateEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
